/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioOperationDefinition;
import filenet.vw.api.VWException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class VWScenarioQueueDefinition
implements Serializable {
    private String m_name = null;
    private int m_id = -1;
    private Map m_operations = Collections.synchronizedMap(new HashMap());

    protected VWScenarioQueueDefinition(String queueName, int queueId) throws VWException {
        this.setName(queueName);
        this.setId(queueId);
    }

    public String getName() {
        return this.m_name;
    }

    protected void setName(String queueName) throws VWException {
        if (queueName == null) {
            throw new VWException("sim.api.VWScenarioQueueDefinition.NullQueueNameParameter", "The queueName parameter can not be null.");
        }
        this.m_name = queueName;
    }

    public int getId() {
        return this.m_id;
    }

    protected void setId(int queueId) {
        this.m_id = queueId;
    }

    public VWScenarioOperationDefinition[] getOperations() {
        if (this.m_operations.size() == 0) {
            return null;
        }
        return this.m_operations.values().toArray(new VWScenarioOperationDefinition[0]);
    }

    protected VWScenarioOperationDefinition createOperation(String operationName, int operationId) throws VWException {
        if (this.m_operations.containsKey(operationName)) {
            throw new VWException("sim.api.VWScenarioQueueDefinition.OperationAlreadyExists", "An operation with the name {0} already exists.", operationName);
        }
        VWScenarioOperationDefinition operation = new VWScenarioOperationDefinition(operationName, operationId);
        this.m_operations.put(operationName, operation);
        return operation;
    }

    protected boolean hasOperation(String operationName) {
        return this.m_operations.containsKey(operationName);
    }
}

